/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mcjty.incontrol.InControl;
import mcjty.incontrol.commands.ModCommands;
import mcjty.incontrol.data.DataStorage;
import mcjty.incontrol.rules.ExperienceRule;
import mcjty.incontrol.rules.LootRule;
import mcjty.incontrol.rules.PotentialSpawnRule;
import mcjty.incontrol.rules.RulesManager;
import mcjty.incontrol.rules.SpawnRule;
import mcjty.incontrol.rules.SummonAidRule;
import mcjty.incontrol.spawner.SpawnerSystem;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class ForgeEventHandlers {
    public static boolean debug = false;

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        int i = 0;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (event.getEntity() instanceof PlayerEntity) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getWorld())) {
            if (rule.isOnJoin() && rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(Level.INFO, "Join Rule " + i + ": " + result + " entity: " + event.getEntity().func_200200_C_() + " y: " + event.getEntity().func_233580_cy_().func_177956_o());
                }
                if (result != Event.Result.DENY) {
                    rule.action(event);
                } else {
                    event.setCanceled(true);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldLast(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d() && event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof PlayerEntity)) {
            InControl.setup.cache.registerSpawn((IWorld)event.getWorld(), event.getEntity().func_200600_R());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.world.field_72995_K) {
            InControl.setup.cache.reset((IWorld)event.world);
            if (!event.world.func_217369_A().isEmpty()) {
                SpawnerSystem.checkRules(event);
            }
            if (event.world.func_234923_W_().equals(World.field_234918_g_)) {
                DataStorage.getData(event.world).tick(event.world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        int i = 0;
        for (SpawnRule rule : RulesManager.getFilteredRules(event.getEntity().func_130014_f_())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(Level.INFO, "Rule " + i + ": " + result + " entity: " + event.getEntity().func_200200_C_() + " y: " + event.getY() + " biome: " + event.getWorld().func_226691_t_(new BlockPos(event.getX(), event.getY(), event.getZ())).getRegistryName());
                }
                if (result != null) {
                    event.setResult(result);
                }
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                if (!rule.isDoContinue()) {
                    return;
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSummonAidEvent(ZombieEvent.SummonAidEvent event) {
        int i = 0;
        for (SummonAidRule rule : RulesManager.getFilteredSummonAidRules(event.getWorld())) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(Level.INFO, "SummonAid " + i + ": " + result + " entity: " + event.getEntity().func_200200_C_() + " y: " + event.getY() + " biome: " + event.getWorld().func_226691_t_(new BlockPos(event.getX(), event.getY(), event.getZ())).getRegistryName());
                }
                event.setResult(result);
                if (result != Event.Result.DENY) {
                    rule.action(event);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        for (PotentialSpawnRule rule : RulesManager.potentialSpawnRules) {
            List<MobSpawnInfo.Spawners> spawnEntries = rule.getSpawnEntries();
            for (MobSpawnInfo.Spawners entry : spawnEntries) {
                event.getSpawns().func_242575_a(entry.field_242588_c.func_220339_d(), entry);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPotentialSpawns(WorldEvent.PotentialSpawns event) {
        int i = 0;
        for (PotentialSpawnRule rule : RulesManager.potentialSpawnRules) {
            if (rule.match(event)) {
                for (int idx = event.getList().size() - 1; idx >= 0; --idx) {
                    if (!rule.getToRemoveMobs().contains(((MobSpawnInfo.Spawners)event.getList().get((int)idx)).field_242588_c)) continue;
                    event.getList().remove(idx);
                }
                List<MobSpawnInfo.Spawners> spawnEntries = rule.getSpawnEntries();
                for (MobSpawnInfo.Spawners entry : spawnEntries) {
                    if (debug) {
                        InControl.setup.getLogger().log(Level.INFO, "Potential " + i + ": " + entry.field_242588_c.getRegistryName().toString());
                    }
                    event.getList().add(entry);
                }
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int i = 0;
        for (ExperienceRule rule : RulesManager.getFilteredExperienceRuiles(event.getEntity().field_70170_p)) {
            if (rule.match(event)) {
                Event.Result result = rule.getResult();
                if (debug) {
                    InControl.setup.getLogger().log(Level.INFO, "Experience Rule " + i + ": " + result + " entity: " + event.getEntity().func_200200_C_() + " y: " + event.getEntity().func_233580_cy_().func_177956_o());
                }
                if (result != Event.Result.DENY) {
                    int newxp = rule.modifyXp(event.getDroppedExperience());
                    event.setDroppedExperience(newxp);
                } else {
                    event.setCanceled(true);
                }
                return;
            }
            ++i;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrops(LivingDropsEvent event) {
        World world = event.getEntity().func_130014_f_();
        int i = 0;
        for (LootRule rule : RulesManager.getFilteredLootRules(world)) {
            if (rule.match(event)) {
                if (debug) {
                    InControl.setup.getLogger().log(Level.INFO, "Loot " + i + ":  entity: " + event.getEntity().func_200200_C_());
                }
                if (rule.isRemoveAll()) {
                    event.getDrops().clear();
                } else {
                    ArrayList<ItemEntity> toRemove = null;
                    for (Predicate<ItemStack> predicate : rule.getToRemoveItems()) {
                        Collection drops = event.getDrops();
                        for (ItemEntity drop : drops) {
                            ItemStack stack = drop.func_92059_d();
                            if (!predicate.test(stack)) continue;
                            if (toRemove == null) {
                                toRemove = new ArrayList<ItemEntity>();
                            }
                            toRemove.add(drop);
                        }
                    }
                    if (toRemove != null) {
                        Collection drops = event.getDrops();
                        for (ItemEntity entity : toRemove) {
                            drops.remove(entity);
                        }
                    }
                }
                for (Pair<ItemStack, Function<Integer, Integer>> pair : rule.getToAddItems()) {
                    ItemStack copy;
                    int amount;
                    ItemStack itemStack = (ItemStack)pair.getLeft();
                    int fortune = event.getLootingLevel();
                    BlockPos pos = event.getEntity().func_233580_cy_();
                    for (amount = ((Integer)((Function)pair.getValue()).apply(fortune)).intValue(); amount > itemStack.func_77976_d(); amount -= itemStack.func_77976_d()) {
                        copy = itemStack.func_77946_l();
                        copy.func_190920_e(itemStack.func_77976_d());
                        event.getDrops().add(new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), copy));
                    }
                    if (amount <= 0) continue;
                    copy = itemStack.func_77946_l();
                    copy.func_190920_e(amount);
                    event.getDrops().add(new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), copy));
                }
            }
            ++i;
        }
    }
}

